/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.sales.service;

import itx.erp.base.service.MetaService;
import itx.erp.customer.model.Customer;
import itx.erp.customer.service.CustomerService;
import itx.erp.exception.ObjectNotFoundException;
import itx.erp.sales.model.Invoice;
import itx.erp.sales.model.InvoiceLine;
import itx.erp.sales.model.Offer;
import itx.erp.sales.model.OfferLine;
import itx.erp.sales.model.Order;
import itx.erp.sales.model.OrderLine;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import jtbcore.db.common.QueryBuilder;
import jtbcore.db.common.QueryResult;
import jtbcore.exception.JTBException;
import jtbcore.model.BaseStringMap;
import jtbcore.service.ServiceBase;
import jtbcore.util.MapUtil;

public class InvoiceService
extends ServiceBase {
    protected CustomerService customerService;
    protected MetaService metaService;

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    public MetaService getMetaService() {
        return this.metaService;
    }

    public void setMetaService(MetaService metaService) {
        this.metaService = metaService;
    }

    public List<String> listInvoiceStatus() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("open");
        l.add("sent");
        l.add("paid");
        l.add("partially");
        return l;
    }

    public QueryResult<Invoice> searchInvoices(Map<String, Object> opts) throws SQLException {
        QueryBuilder b = new QueryBuilder(this.connection);
        b.setTable("sales__invoice");
        b.addSelectField("sales__invoice", "invoice_id");
        b.addSelectField("sales__invoice", "customer_id");
        b.addSelectField("sales__invoice", "invoice_date");
        b.addSelectField("sales__invoice", "invoice_status");
        b.addSelectField("sales__invoice", "invoice_number");
        b.addSelectField("sales__invoice", "subject");
        b.addSelectField("sales__invoice", "total_calculated_price");
        b.addSelectField("sales__invoice", "total_calculated_price_incl_vat");
        b.addSelectField("sales__invoice", "edited");
        b.addSelectField("sales__invoice", "created");
        b.addSelectField("customer__customer", "customer_name");
        b.addLeftJoin("customer__customer", "customer__customer.customer_id = sales__invoice.customer_id");
        if (MapUtil.hasProperty(opts, "q")) {
            String q = opts.get("q").toString().trim();
            b.addWhere(" customer__customer.customer_name like ? or sales__invoice.invoice_number like ? or sales__invoice.subject like ?", "%" + q + "%", "%" + q, "%" + q + "%");
        }
        b.setRawOrderBy("invoice_id desc");
        ResultSet rs = b.queryResultSet();
        QueryResult<Invoice> qr = new QueryResult<Invoice>();
        if (opts.containsKey("start")) {
            qr.setStart((Integer)opts.get("start"));
        }
        if (opts.containsKey("pageSize")) {
            qr.setPageSize((Integer)opts.get("pageSize"));
        }
        qr.fill(Invoice.class, rs);
        rs.close();
        return qr;
    }

    public Invoice readInvoice(Integer invoiceId) throws SQLException, JTBException {
        Invoice o = (Invoice)this.queryToObject(Invoice.class, "select * from sales__invoice where invoice_id = ?", invoiceId);
        if (o == null) {
            throw new ObjectNotFoundException("Invoice not found");
        }
        List l = this.queryToList(InvoiceLine.class, "select * from sales__invoice_line where invoice_id = ? order by sort", invoiceId);
        o.setLines(l);
        if (o.getCustomerId() != null) {
            Customer cust = this.customerService.readCustomer(o.getCustomerId());
            o.setCustomer(cust);
        }
        return o;
    }

    public Integer saveInvoice(Invoice inv) throws IOException, SQLException, JTBException {
        Invoice oldInvoice = null;
        if (inv.getInvoiceId() != null) {
            oldInvoice = this.readInvoice(inv.getInvoiceId());
        }
        if (inv.getInvoiceNumber() == null) {
            Integer newInvoiceNo = (Integer)this.connection.queryValue("select max(invoice_number) from sales__invoice", Integer.class, new Object[0]);
            newInvoiceNo = newInvoiceNo == null || newInvoiceNo == 0 ? 1000 : newInvoiceNo + 1;
            inv.setInvoiceNumber(newInvoiceNo);
        }
        long totalExclVat = 0L;
        long totalInclVat = 0L;
        for (InvoiceLine ol : inv.getLines()) {
            if ("text".equals(ol.getLineType())) continue;
            Double et = 0.0;
            if (ol.getAmount() != null && ol.getPriceExclVat() != null) {
                et = ol.getAmount() * ol.getPriceExclVat() * 100.0;
            }
            totalExclVat += (long)et.intValue();
            Double it = 0.0;
            if (ol.getAmount() != null && ol.getPriceInclVat() != null) {
                it = ol.getAmount() * ol.getPriceInclVat() * 100.0;
            }
            totalInclVat += (long)it.intValue();
        }
        inv.setTotalCalculatedPrice((double)totalExclVat / 100.0);
        inv.setTotalCalculatedPriceInclVat((double)totalInclVat / 100.0);
        Integer invoiceId = this.connection.save("sales__invoice", "invoice_id", inv.getBaseStringMap());
        inv.setInvoiceId(invoiceId);
        List<InvoiceLine> lines = inv.getLines();
        int x = 0;
        while (x < lines.size()) {
            Integer oldLineId = null;
            if (oldInvoice != null && x < oldInvoice.getLines().size()) {
                oldLineId = oldInvoice.getLines().get(x).getInvoiceLineId();
            }
            InvoiceLine newLine = lines.get(x);
            newLine.setInvoiceLineId(oldLineId);
            newLine.setInvoiceId(invoiceId);
            this.connection.save("sales__invoice_line", "invoice_line_id", newLine.getBaseStringMap());
            ++x;
        }
        if (oldInvoice != null) {
            while (x < oldInvoice.getLines().size()) {
                Integer olid = oldInvoice.getLines().get(x).getInvoiceLineId();
                this.connection.query("delete from sales__invoice_line where invoice_line_id = ?", olid);
                ++x;
            }
        }
        return invoiceId;
    }

    public void deleteInvoice(Integer invoiceId) throws IOException, SQLException, JTBException {
        Invoice inv = this.readInvoice(invoiceId);
        this.connection.query("delete from sales__invoice_line where invoice_id = ?", invoiceId);
        this.connection.query("delete from sales__invoice where invoice_id = ?", invoiceId);
    }

    public Invoice createInvoice(Offer of) throws IOException, SQLException, JTBException {
        Invoice inv = new Invoice();
        inv.setSubject(of.getSubject());
        inv.setInvoiceDate(new Date());
        inv.setCustomerId(of.getCustomerId());
        inv.setInternalNote(of.getInternalNote());
        inv.setInvoiceStatus("open");
        ArrayList<InvoiceLine> invlines = new ArrayList<InvoiceLine>();
        for (OfferLine ol : of.getLines()) {
            InvoiceLine il = new InvoiceLine();
            il.setLineType(ol.getLineType());
            il.setArticleId(ol.getArticleId());
            il.setAmount(ol.getAmount());
            il.setPriceExclVat(ol.getPriceExclVat());
            il.setPriceInclVat(ol.getPriceInclVat());
            il.setShortDescription(ol.getShortDescription());
            il.setVatPercentage(ol.getVatPercentage());
            invlines.add(il);
        }
        inv.setLines(invlines);
        this.saveInvoice(inv);
        this.metaService.addMeta(Invoice.class.getName(), inv.getInvoiceId(), "offerId", of.getOfferId().toString());
        return inv;
    }

    public Invoice createInvoice(Order ord) throws IOException, SQLException, JTBException {
        Invoice inv = new Invoice();
        inv.setSubject(ord.getSubject());
        inv.setInvoiceDate(new Date());
        inv.setCustomerId(ord.getCustomerId());
        inv.setInternalNote(ord.getInternalNote());
        ArrayList<InvoiceLine> invlines = new ArrayList<InvoiceLine>();
        for (OrderLine ol : ord.getLines()) {
            InvoiceLine il = new InvoiceLine();
            il.setLineType(ol.getLineType());
            il.setArticleId(ol.getArticleId());
            il.setAmount(ol.getAmount());
            il.setPriceExclVat(ol.getPriceExclVat());
            il.setPriceInclVat(ol.getPriceInclVat());
            il.setShortDescription(ol.getShortDescription());
            invlines.add(il);
        }
        inv.setLines(invlines);
        this.saveInvoice(inv);
        this.metaService.addMeta(Invoice.class.getName(), inv.getInvoiceId(), "orderId", ord.getOrderId().toString());
        return inv;
    }

    public List<Invoice> listByOffer(Integer offerId) throws SQLException, JTBException {
        String sql = "select * from sales__invoice where invoice_id in (select object_id  from base__object_meta  where object_key = ?  and object_name = 'offerId' and object_value = ? )";
        List invoices = this.queryToList(Invoice.class, sql, Invoice.class.getName(), offerId);
        return invoices;
    }

    public List<Invoice> listByOrder(Integer orderId) throws SQLException, JTBException {
        String sql = "select * from sales__invoice where invoice_id in (select object_id  from base__object_meta  where object_key = ?  and object_name = 'orderId' and object_value = ? )";
        List invoices = this.queryToList(Invoice.class, sql, Invoice.class.getName(), orderId);
        return invoices;
    }

    public List<Invoice> invoicesFromOffersOfOrder(Integer orderId) throws SQLException, JTBException {
        String sql = "select object_value offerId from base__object_meta where object_key='itx.erp.sales.model.Order' \tand object_name='offerId'  and object_id = ?";
        List<BaseStringMap> offers = this.connection.queryBsmList(sql, orderId);
        ArrayList<Invoice> list = new ArrayList<Invoice>();
        for (BaseStringMap rec : offers) {
            Integer offerId = rec.getPropertyInt("offerId");
            List<Invoice> invoices = this.listByOffer(offerId);
            list.addAll(invoices);
        }
        return list;
    }
}

